package com.one.stargame.game;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

public class ConnectionsActivity extends AppCompatActivity implements View.OnClickListener  {

    Button mobileButton = null;
    Button wifiButton = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate( savedInstanceState );
        setContentView( R.layout.activity_connections );

        mobileButton = (Button) findViewById( R.id.mobileButton );
        mobileButton.setOnClickListener( this );

        wifiButton = (Button) findViewById( R.id.wifiButton );
        wifiButton.setOnClickListener( this );
    }

    @Override
    protected void onResume() {
        super.onResume();
        if( checkInternet() )
        {
            onBackPressed();
        }
    }

    // проверяет состояние подключения к интернету
    public boolean checkInternet()
    {
        // internet
        ConnectivityManager connectivity = (ConnectivityManager)getSystemService( Context.CONNECTIVITY_SERVICE);
        if (connectivity != null)   {
            NetworkInfo[] info = connectivity.getAllNetworkInfo();
            if (info != null) {
                for (int i = 0; i < info.length; i++) {
                    if (info[i].getState() == NetworkInfo.State.CONNECTED) {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    @Override
    public void onClick( View v)
    {
        switch ( v.getId() ) {
            case R.id.mobileButton:
                startActivity(new Intent( Settings.ACTION_DATA_ROAMING_SETTINGS));
                break;
            case R.id.wifiButton:
                startActivity(new Intent( Settings.ACTION_WIFI_SETTINGS));
                break;
            default:
                break;
        }
    }

    public void onBackPressed()
    {
        if( checkInternet() )
        {
            finish();
        }
    }
}
